﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using Microsoft.Xna.Framework;
using GE.Visualisation;
using GE.Physics;
using GE.Physics.Shapes;

namespace GE.World.Entities
{
    /// <summary>
    /// When activated, it locks the camera
    /// </summary>
    class CameraLockerEntity : WorldEntity
    {
        /// <summary>
        /// The rectangle to trigger the entity
        /// </summary>
        StaticShapeRectangle _triggerShape;

        /// <summary>
        /// The direction to lock the camera when this entity is triggered
        /// </summary>
        eLockedDirection _lockedDirection;

        /// <summary>
        /// The position the camera gotta be locked to
        /// </summary>
        Vector2 _v2LockPosition;

        /// <summary>
        /// Flag set if the entity has to use the lock position
        /// </summary>
        bool _bUseLockPosition;

        public Vector2 LockPosition { set { _v2LockPosition = value; } }

        public bool UseLockPosition { set { _bUseLockPosition = value; } }

        /// <summary>
        /// Set the rectangle used as a trigger to activate the entity
        /// </summary>
        public Rectangle Trigger
        {
            set
            {
                _triggerShape = new StaticShapeRectangle(value.Width, value.Height, Vector2.Zero, new Vector2(value.X, value.Y), 0, this);
            }
        }
#if !GAME
        public static string EDITOR_TILESET { get { return "editorSprite.xml"; } }

        public static string EDITOR_SPRITE { get { return "cameraLocker"; } }
#endif
        /// <summary>
        /// Set the direction to lock.
        /// </summary>
        public eLockedDirection LockedDirection { set { _lockedDirection = value; } }

        /// <summary>
        /// Constructor
        /// </summary>
        public CameraLockerEntity()
            : base()
        {
            _triggerShape = null;
            _lockedDirection = eLockedDirection.eLockedNone;
        }

        /// <summary>
        /// Update
        /// </summary>
        public override void update()
        {
            //check collision with the player
            CollisionResult res = Physics.Physics.Instance.checkFirstRegisteredCollisionEx(_triggerShape, (int)ePhysicGroup.ePhysicPlayer);

            //no collision
            if (res == null) return;

            //collision
            World.Instance.CameraEntity.LockedDirection = _lockedDirection;

            if (_bUseLockPosition)
            {
                switch (_lockedDirection)
                {
                    case eLockedDirection.eLockedHorizontal:
                        World.Instance.CameraEntity.setCenterX(_v2LockPosition.X);
                        break;

                    case eLockedDirection.eLockedVertical:
                        World.Instance.CameraEntity.setCenterY(_v2LockPosition.Y);
                        break;

                    case eLockedDirection.eLockedBoth:
                        World.Instance.CameraEntity.setCenterX(_v2LockPosition.X);
                        World.Instance.CameraEntity.setCenterY(_v2LockPosition.Y);
                        break;
                }
            }
        }



    }
}
